/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import javax.annotation.Nonnull;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderData
extends RenderData {
    @Nonnull
    public final FluidStack fluidType;

    public FluidRenderData(@Nonnull FluidStack fluidType) {
        this.fluidType = fluidType;
    }

    @Override
    public boolean isGaseous() {
        return this.fluidType.getFluid().getAttributes().isGaseous(this.fluidType);
    }

    public int getColorARGB() {
        return MekanismRenderer.getColorARGB(this.fluidType);
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.fluidType, scale);
    }

    @Override
    public int calculateGlowLight(int light) {
        return MekanismRenderer.calculateGlowLight(light, this.fluidType);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getFluidTexture(this.fluidType, MekanismRenderer.FluidType.STILL);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.fluidType.getFluid().getRegistryName().hashCode();
        if (this.fluidType.hasTag()) {
            code = 31 * code + this.fluidType.getTag().hashCode();
        }
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object data) {
        if (!super.equals(data)) return false;
        if (!(data instanceof FluidRenderData)) return false;
        FluidRenderData other = (FluidRenderData)data;
        if (!this.fluidType.isFluidEqual(other.fluidType)) return false;
        return true;
    }
}

